#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install(c("limma", "car", "ridge", "preprocessCore", "genefilter", "sva", "biomaRt"))
#BiocManager::install(c("GenomicFeatures", "maftools", " stringr", "org.Hs.eg.db"))
#BiocManager::install("TxDb.Hsapiens.UCSC.hg19.knownGene")

#install.packages("oncoPredict")


#library packages
library(limma)
library(oncoPredict)
library(parallel)
set.seed(123)

expFile="Rembrandt_mRNA_array_475.txt"     #expression data
setwd("E:\\metabolism\\LGG\\16.ANN_validation\\Rembrandt\\6.drugsens\\oncoPredict\\oncoPredict")     #set cd

#Read the expression input file and tidy up the data
rt = read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp), colnames(exp))
data=matrix(as.numeric(as.matrix(exp)), nrow=nrow(exp), dimnames=dimnames)
data=avereps(data)
data=data[rowMeans(data)>0.5,]
data=t(data)
rownames(data)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-(.*?)\\-(.*)", "\\1\\-\\2\\-\\3", rownames(data))
data=avereps(data)
data=t(data)

#Read drug susceptibility files
GDSC2_Expr=readRDS(file='GDSC2_Expr.rds')
GDSC2_Res=read.table("GDSC2_AUC.txt", header=T, sep="\t", check.names=F)
rownames(GDSC2_Res)=GDSC2_Res[,1]
GDSC2_Res=GDSC2_Res[,-1]
GDSC2_Res=as.matrix(GDSC2_Res)


#drug susceptibility
calcPhenotype(trainingExprData = GDSC2_Expr,
              trainingPtype = GDSC2_Res,
              testExprData = data,
              batchCorrect = 'eb',      #"eb" for ComBat  
              powerTransformPhenotype = TRUE,
              removeLowVaryingGenes = 0.2,
              minNumSamples = 10, 
              printOutput = TRUE, 
              removeLowVaringGenesFrom = 'rawData')

